<?php

class JSS_Image_Widget extends WP_Widget {
	
	function __construct() {
		parent::__construct(
			'jss_image_widget',
			'Imagen', 
			array(
				'description' => 'Añade una imagen personalizada.'
			)
		);
	}
	
	public function widget($args, $instance) {
		$defaults = array(
			'title' => '', 
			'image'=> '', 
			'url' => '',
			'target' => '',
			'class' => ''
		);
		$instance = wp_parse_args($instance, $defaults);
		
		$title = $instance['title'];
		$image = $instance['image'];
		$url = $instance['url'];
		$target = $instance['target'];
		$class = $instance['class'];
		if($class){
			$class = ' '.$class;
		}
		echo $args['before_widget'];
		if($title) {
			echo $args['before_title'].apply_filters( 'widget_title', $title).$args['after_title'];
		}
		$thumbnail = get_theme_image($image);
		if($thumbnail->ID){
			$html = '';
			$html .= '
				<img src="'.$thumbnail->url.'" alt="'.$thumbnail->alt.'" />
			';
			if($url){
				$target_html = '';
				if($target){
					$target_html = 'target="_blank"';
				}
				$html = '
					<a href="'.$url.'" '.$target_html.'>
						<img src="'.$thumbnail->url.'" alt="'.$thumbnail->alt.'" />
					</a>
				';
			}
			echo '
				<div class="jss_image_widget'.$class.'">
					'.$html.'
				</div>
			';
		}
		echo $args['after_widget'];
	}
	
	public function form($instance) {
		$defaults = array(
			'title' => '', 
			'image'=> '', 
			'url' => '',
			'target' => '',
			'class' => ''
		);
		$instance = wp_parse_args($instance, $defaults);
		
		$title = $instance['title'];
		$image = $instance['image'];
		$url = $instance['url'];
		$target = $instance['target'];
		$class = $instance['class'];
		
		$title_id = $this->get_field_id('title');
		$title_name = $this->get_field_name('title');
		$image_id = $this->get_field_id('image');
		$image_name = $this->get_field_name('image');
		$url_id = $this->get_field_id('url');
		$url_name = $this->get_field_name('url');
		$target_id = $this->get_field_id('target');
		$target_name = $this->get_field_name('target');
		$class_id = $this->get_field_id('class');
		$class_name = $this->get_field_name('class');
		$checked_target = '';
		if($target){
			$checked_target = 'checked';
		}
		
		$thumbnail = get_theme_image($image);
		$class_thumbnail = '';
		if($thumbnail->ID){
			$class_thumbnail = ' active';
		}
		
		$html = '
			<p>
				<label for="'.$title_id.'">Título</label> 
				<input class="widefat" id="'.$title_id.'" name="'.$title_name.'" type="text" value="'.$title.'">
			</p>
			<p>
				<button class="button add-custom-theme-image" type="button" data-img="#custom-theme-'.$image_id.'-img" data-input="#custom-theme-'.$image_id.'" data-remove="remove-custom-theme-'.$image_id.'">Agregar / Editar imagen</button>
				<img src="'.$thumbnail->url.'" class="custom-theme-img'.$class_thumbnail.'" id="custom-theme-'.$image_id.'-img" />
				<a href="#" id="remove-custom-theme-'.$image_id.'" data-img="#custom-theme-'.$image_id.'-img" data-input="#custom-theme-'.$image_id.'" class="remove-custom-theme-image">Quitar imagen</a>
				<input type="hidden" value="'.$thumbnail->ID.'" id="custom-theme-'.$image_id.'" name="'.$image_name.'">
			</p>
			<p>
				<label for="'.$url_id.'">URL</label> 
				<input class="widefat" id="'.$url_id.'" name="'.$url_name.'" type="text" value="'.$url.'">
			</p>
			<p>
				<label for="'.$target_id.'"> 
					<input class="widefat" id="'.$target_id.'" name="'.$target_name.'" type="checkbox" value="1" '.$checked_target.'> Abrir en nueva pestaña
				</label>
			</p>
			<p>
				<label for="'.$class_id.'">Clases (CSS)</label> 
				<input class="widefat" id="'.$class_id.'" name="'.$class_name.'" type="text" value="'.$class.'">
			</p>
		';
		echo $html;
	}
	
	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance['title'] = $new_instance['title'];
		$instance['image'] = $new_instance['image'];
		$instance['url'] = $new_instance['url'];
		$instance['target'] = $new_instance['target'];
		$instance['class'] = $new_instance['class'];
		return $instance;
	}
}