import 'bootstrap-sass';
import 'owl.carousel';
import './jquery.fancybox.min';

let isReady = false;

const resize = () => {

};

$(() => {
    isReady = true;
    $('.owl-fundaciones').each((i, el) => {
        $(el).owlCarousel({
            autoHeight: true,
            loop: true,
            responsive: {
                0: {
                    items: 1,
                },
                768: {
                    items: 2,
                },
            },
        });
    });
    $('.owl-product-gallery').each((i, el) => {
        $(el).owlCarousel({
            autoHeight: true,
            items: 1
        });
    });
	$('.owl-control').click((e) => {
	    const $this = e.currentTarget;
        const owl = $($this).data('owl');
        const direction = $($this).data('direction');
        $(owl).trigger(`${direction}.owl.carousel`);
		e.preventDefault();
    });
	$('#show-menu').click((e) => {
		$('#nav-main-menu').addClass('active');
		e.preventDefault();
	});
	$('#close-menu').click((e) => {
		$('#nav-main-menu').removeClass('active');
		e.preventDefault();
	});
	$('.category-filter').click((e) => {
	    const $this = $(e.currentTarget);
        const category = $($this).data('category');
        $('.category-filter').removeClass('active');
        $this.addClass('active');
        if(category === '*'){
	        $('.grid-product').removeClass('inactive');
        } else {
	        $('.grid-product').addClass('inactive');
	        $(category).removeClass('inactive');
	    }
		e.preventDefault();
    });
    $('.color-hover').hover(
        (e) => {
            const $this = $(e.currentTarget);
            const name = $this.data('name');
            const price = $this.data('price');
            const color_title = $this.data('color-title');
            $(color_title).html(`${name} <span>${price}</span>`);
        },
        (e) => {}
    );
    $('.product-gallery-thumbnail').click((e) => {
        const $this = $(e.currentTarget);
        const owl = $($this).data('owl');
        const slide = $($this).data('slide');
        $(owl).trigger('to.owl.carousel', slide);
        e.preventDefault();
    });
    $('.product-color').each((i, e) => {
        const $this = $(e);
        if($this.is(':checked')){
            $('.price-color').removeClass('active');
            const price_color = $this.data('price-color');
            $(price_color).addClass('active');
        }
    });
    $('.product-color').change((e) => {
        const $this = $(e.currentTarget);
        if($this.is(':checked')){
            $('.price-color').removeClass('active');
            const price_color = $this.data('price-color');
            $(price_color).addClass('active');
        }
    });

    $('#coupon_code, #username, #password').addClass('input-sm form-control');

    $('[data-toggle="tooltip"]').tooltip();
    $('a.fancybox, .fancybox a').fancybox();
    resize();
	console.log('ready');
});

$(window).on('resize', () => {
    resize();
});

$(window).on('load', () => {
	if(isReady){
        $('.owl-fundaciones').each((i, el) => {
            $(el).trigger('refreshed.owl.carousel');
        });
        $('.owl-product-gallery').each((i, el) => {
            $(el).trigger('refreshed.owl.carousel');
        });
    }
    resize();
});