var $ = jQuery.noConflict();
	
var fancybox_options = {
	padding: 0,
	openEffect: 'elastic',
	helpers : {
		media : {}
	}
};

function custom_theme_image(){
	
	$('.add-custom-theme-image').click(function(){
		var _img = $(this).data('img');
		var _input = $(this).data('input');
		wp.media.editor.send.attachment = function(props, attachment) {
			var url = attachment.url;
			var id = attachment.id;
			$(_img).attr('src', url);
			$(_img).addClass('active');
			$(_input).val(id);
		}
		wp.media.editor.open();
	});
	
	$('.remove-custom-theme-image').click(function(e){
		var _img = $(this).data('img');
		var _input = $(this).data('input');
		$(_img).attr('src', '');
		$(_img).removeClass('active');
		$(_input).val('');
		e.preventDefault();
	});
	
	$('.add-custom-theme-file').click(function(){
		var _img = $(this).data('img');
		var _input = $(this).data('input');
		wp.media.editor.send.attachment = function(props, attachment) {
			var icon = attachment.icon;
			var id = attachment.id;
			$(_img).attr('src', icon);
			$(_img).addClass('active');
			$(_input).val(id);
		}
		wp.media.editor.open();
	});
	
	$('.remove-custom-theme-file').click(function(e){
		var _img = $(this).data('img');
		var _input = $(this).data('input');
		var _url = $(this).data('url');
		$(_img).attr('src', '');
		$(_img).removeClass('active');
		$(_url).attr('href', '');
		$(_input).val('');
		e.preventDefault();
	});
	
	$('.datepicker').datepicker({
		changeMonth: true,
		changeYear: true
	});
	
}

$(window).load(function(){

});

$(document).ready(function(){
	
	custom_theme_image();

	$('#add-image-gallery').click(function() {		
		wp.media.editor.send.attachment = function(props, attachment) {
			var li = $('<li>', {});
			var a = $('<a>', {
				'href': '#',
				'class': 'remove',
				'html': '<span class="dashicons dashicons-dismiss"></span>'
			});
			a.click(function(e){
				li.fadeOut('fast', function(){
					li.remove();
				});
				e.preventDefault();
			});
			var img = $('<img>', {
				'src': attachment.sizes.thumbnail.url,
				'alt': '',
				'title': attachment.title
			});
			var input = $('<input>', {
				'type': 'hidden',
				'value': attachment.id,
				'name': 'gallery[]'
			});
			li.append(a);
			li.append(img);
			li.append(input);
			$('#gallery-sortable').append(li);
		}
	
		wp.media.editor.open();
	});

	$('#gallery-sortable li').each(function(){
		var li = $(this);
		var a = $('a', li);
		a.click(function(e){
			li.fadeOut('fast', function(){
				li.remove();
			});
			e.preventDefault();
		});
	});

	$('#gallery-sortable').sortable({
		revert: true
    });

    $('#asistentes > div').each(function(){
    	var div = $(this);
    	var a = $('a', this);
    	a.click(function(e){
			div.fadeOut('fast', function(){
				div.remove();
			});
			e.preventDefault();
		});
    });

    $('#add-asistente').click(function(){
    	var asistente_id = $('#asistente-select').val();
    	var text = $("#asistente-select option:selected").text();
    	if(asistente_id != ''){
			var div = $('<div>', {});
			var span = $('<span>', {
				'html': text
			});
			var a = $('<a>', {
				'href': '#',
				'class': 'remove-asistente',
				'html': '<span class="dashicons dashicons-dismiss"></span>'
			});
			a.click(function(e){
				div.fadeOut('fast', function(){
					div.remove();
				});
				e.preventDefault();
			});
			var input = $('<input>', {
				'type': 'hidden',
				'value': asistente_id,
				'name': 'asistentes[]'
			});
			div.append(span);
			div.append(a);
			div.append(input);
			$('#asistentes').append(div);
		}
    });
	
	$('a.fancybox, .fancybox a').fancybox(fancybox_options);
	
	$('.no-enter').keypress(function(e){
		if (e.keyCode == 10 || e.keyCode == 13){
			e.preventDefault();
		}
	});
	
});

$(document).ajaxComplete(function(event, xhr, options) {
    if (xhr && xhr.readyState === 4 && xhr.status === 200 && options.data) {
		if(options.data.indexOf('action=add-tag') >= 0){
			/*var res = wpAjax.parseAjaxResponse(xhr.responseXML, 'ajax-response');
			if (!res || res.errors) {
				return;
			}*/
			if($('#term-image').length > 0){
				$('#term-image').val('');
				$('#term-img').removeClass('active');
			}
		}
		if(options.data.indexOf('widget-jss_image_widget') >= 0 && options.data.indexOf('add_new=multi') >= 0){
			custom_theme_image();
		}
		if(options.data.indexOf('widget-jss_popup_widget') >= 0 && options.data.indexOf('add_new=multi') >= 0){
			custom_theme_image();
		}
    }
});