<?php
	$year = date('Y');
	$years = array($year, $year + 1);
	$data = array();
	foreach($years as $year){
		for($month = 1; $month <= 12; $month++){
			$time = mktime(0, 0, 0, $month, 1, $year);
			$t = date('t', $time);
			$w = date('w', $time);
			$n = date('n', $time);

			$days = array();
			for($i = 1; $i <= $t; $i++){
				$days[] = $i;
			}
			for($i = 0; $i < $w; $i++){
				array_unshift($days, 0);
			}
			$days = array_chunk($days, 7);
			$last_index = count($days) - 1;
			$last = $days[$last_index];
			for($i = count($last); $i < 7; $i++){
				array_push($days[$last_index], 0);
			}
			$data[$year][$month] = $days;
		}
	}
?>

	<div class='months'>
		<div id="carousel-month" class="carousel slide carousel-month" data-interval="null">
			<div class="carousel-inner" role="listbox">

				<?php foreach($data as $year => $months){ ?>
					<?php foreach($months as $month => $days){ ?>
						<div class='item<?php if($month.$year == date('nY')){ ?> active<?php } ?>'>
							<div class='month'>
								<div class='month-name'>
									<div><?php _p(month_name($month)); ?> <?php _p($year); ?></div>
									<a href="#carousel-month" role="button" data-slide="prev" class='left'>
										<i class="fa fa-chevron-circle-left" aria-hidden="true"></i>
									</a>
									<a href="#carousel-month" role="button" data-slide="next" class='right'>
										<i class="fa fa-chevron-circle-right" aria-hidden="true"></i>
									</a>
								</div>
								<table class='table'>
									<thead>
										<tr>
											<th>D</th>
											<th>L</th>
											<th>M</th>
											<th>M</th>
											<th>J</th>
											<th>V</th>
											<th>S</th>
										</tr>
									</thead>
									<tbody>
										<?php foreach($days as $_days){ ?>
											<tr>
												<?php foreach($_days as $day){ ?>
													<td>
														<?php if($day){ ?>
															<?php
																$current_time = mktime(0, 0, 0, $month, $day, $year);
																$date1 = date('dmY', $current_time);
																$cond = false;
																foreach($calendario as $event){
																	$date2 = date('dmY', $event->time);
																	if($date1 == $date2){
																		$cond = true;
																		break;
																	}
																}
															?>
															<?php if($cond){ ?>
																<a href='#' class='show-events' data-events='.events-<?php _p($date1); ?>'><?php _p($day); ?></a>
															<?php } else { ?>
																<span><?php _p($day); ?></span>
															<?php } ?>
														<?php } ?>
													</td>
												<?php } ?>
											</tr>
										<?php } ?>
									</tbody>
								</table>
							</div>
						</div>

					<?php } ?>
				<?php } ?>
				
			</div>
		</div>

	</div>
	<div class='events-list'>
		<?php foreach($calendario as $event){ ?>
			<?php $time = date('dmY', $event->time); ?>
			<div class='event-list active events-<?php _p($time); ?>'>
                <div class='image' style='background-image: url(<?php _p($event->image); ?>)'></div>
                <div class='info'>
                    <div class='title'><?php _p($event->title); ?></div>
                    <div class='content'><?php _p($event->content); ?></div>
                </div>
                <div class='date'><?php _p($event->date); ?></div>
			</div>
		<?php } ?>
	</div>
